#!/bin/ksh

export ERL_TOP=$BUILD/otp_src_19.2
cd $ERL_TOP || exit 1;
## Environnement de build


RPM_SOURCE_DIR="$SOURCES"
RPM_BUILD_DIR="$BUILD"
RPM_OPT_FLAGS="-O2 -fsigned-char"
RPM_ARCH="ppc"
RPM_OS="aix"
export RPM_SOURCE_DIR RPM_BUILD_DIR RPM_OPT_FLAGS RPM_ARCH RPM_OS
RPM_DOC_DIR="/opt/freeware/doc"
export RPM_DOC_DIR
RPM_PACKAGE_NAME="erlang"
RPM_PACKAGE_VERSION="19.2"
RPM_PACKAGE_RELEASE="2"
export RPM_PACKAGE_NAME RPM_PACKAGE_VERSION RPM_PACKAGE_RELEASE
LIBPATH="/opt/freeware/lib"

umask 022

export RM="/usr/bin/rm -f"
export AR="/usr/bin/ar"
export NM="/usr/bin/nm -X32_64"

export CC="/opt/freeware/bin/gcc"
export CXX="/opt/freeware/bin/g++"
export LDFLAGS="-L/opt/freeware/lib"
export FLAGS="-maix32"

# Set up proper cflags/cxxflags first
ERL_FLAGS="${RPM_OPT_FLAGS} -fno-strict-aliasing -D_LINUX_SOURCE_COMPAT"

CFLAGS="${ERL_FLAGS} -maix32" CXXFLAGS="${ERL_FLAGS} -maix32"
CFLAGS="${CFLAGS:--O2 -fsigned-char}" ; export CFLAGS ;
CXXFLAGS="${CXXFLAGS:--O2 -fsigned-char}" ; export CXXFLAGS ;
FFLAGS="${FFLAGS:--O2 -fsigned-char}" ; export FFLAGS ;

unset AIX64
unset AIX32
AIX32=true


export TESTROOT=$ERL_TOP/release/tests/


## Environnement du programme lance_reste_tests



export REPTEST=release/tests
export R2=/opt/freeware/src/packages/BUILD/otp_src_19.2
export R3=/opt/freeware/src/packages/BUILD/gcc-build-7-20161219
export LIBPATH="/opt/freeware/lib"

export ERL_PATH="$ERL_TOP/$REPTEST/$TEST:$ERL_TOP/bin/powerpc-ibm-aix6.1:$ERL_TOP/bin:/usr/local/bin/:/opt/freeware/bin:/usr/linux/bin:/usr/local/bin:/usr/bin:/etc:/usr/sbin:/usr/ucb:/usr/bin/X11:/sbin:/usr/java5/jre/bin:/usr/java5/bin:/usr/samples/kernel:/usr/java131/jre/bin:/usr/java131/bin:/usr/java14/jre/bin:/usr/java14/bin:."

fonct_lance()
{
    #    echo "\nLancement de la suite de tezsts : REpertoire:$1 test:$2\n"

    TEST=$1"_test"
    CRASH_DUMP=$2"_erl_crash.dump"
    REP=$3
    SPEC=$4
    set -x

    echo -eval "ts_run:ct_run_test(\"/home2/freeware/src/packages/BUILD/otp_src_19.2/release/tests/$TEST\", [{abort_if_missing_suites,true},{spec,[\"$SPEC.spec\"]},{allow_user_terms,true},{logdir,\"../test_server\"},{config,[\"../test_server/ts.config\",\"../test_server/ts.unix.config\"]},{vars,[{verbose,0}]},batch,{scale_timetraps,true}])"

    erl -sname test_server -rsh rsh -env PATH "$ERL_PATH" -env ERL_CRASH_DUMP $ERL_TOP/$REPTEST/test_server/$CRASH_DUMP -boot start_sasl -sasl errlog_type error -pz "$ERL_TOP/$REPTEST/test_server" -ct_test_vars "{net_dir,\"\"}" -eval "ts_run:ct_run_test(\"/home2/freeware/src/packages/BUILD/otp_src_19.2/release/tests/$TEST\", [{abort_if_missing_suites,true},{spec,[\"$SPEC.spec\"]},{allow_user_terms,true},{logdir,\"../test_server\"},{config,[\"../test_server/ts.config\",\"../test_server/ts.unix.config\"]},{vars,[{verbose,0}]},batch,{scale_timetraps,true}])"  -noinput -eval "erlang:halt(0,[{flush,false}])."

}


# 46 applications de tests
export LISTE="
emulator:emulator:emulator:emulator_smoke
kernel:kernel:kernel:kernel_smoke
erl_interface:erl_interface:erl_interface:erl_interface_smoke
ic:ic:ic:ic_smoke
os_mon:os_mon:os_mon:os_mon_smoke
system:system:system:system_smoke
emulator:emulator:emulator:emulator
kernel:kernel:kernel:kernel
stdlib:stdlib:stdlib:stdlib
compiler:compiler:compiler:compiler
hipe:hipe:hipe:hipe
erl_interface:erl_interface:erl_interface:erl_interface
sasl:sasl:sasl:sasl
tools:tools:tools:tools
runtime_tools:runtime_tools:runtime_tools:runtime_tools
parsetools:parsetools:parsetools:parsetools
ic:ic:ic:ic
orber:orber:orber:orber
inets:inets:inets:inets
asn1:asn1:asn1:asn1
os_mon:os_mon:os_mon:os_mon
snmp:snmp:snmp:snmp
mnesia:mnesia:mnesia:mnesia
cosEvent:cosEvent:cosEvent:cosEvent
cosEventDomain:cosEventDomain:cosEventDomain:cosEventDomain
cosFileTransfer:cosFileTransfer:cosFileTransfer:cosFileTransfer
cosNotification:cosNotification:cosNotification:cosNotification
cosProperty:cosProperty:cosProperty:cosProperty
cosTime:cosTime:cosTime:cosTime
cosTransactions:cosTransactions:cosTransactions:cosTransactions
crypto:crypto:crypto:crypto
diameter:diameter:diameter:diameter
edoc:edoc:edoc:edoc
eldap:eldap:eldap:eldap
epmd:epmd:epmd:epmd
erl_docgen:erl_docgen:erl_docgen:erl_docgen
eunit:eunit:eunit:eunit
gs:gs:gs:gs
odbc:odbc:odbc:odbc
percept:percept:percept:percept
public_key:public_key:public_key:public_key
ssh:ssh:ssh:ssh
ssl:ssl:ssl:ssl
syntax_tools:syntax_tools:syntax_tools:syntax_tools
xmerl:xmerl:xmerl:xmerl
system:system:system:system
"



# Make -k dans mles sous rpertoires avant de commencer les tests


for LIGNE in $LISTE;
do
    P1=$(echo $LIGNE|awk -F: '{print $1}')
    P2=$(echo $LIGNE|awk -F: '{print $2}')
    P3=$(echo $LIGNE|awk -F: '{print $3}')
    P4=$(echo $LIGNE|awk -F: '{print $4}')
    LOG=traces.lance_all_tests.$P1.$P2.$P3.$P4.[0-9]*.log
    [ -e $LOG ] && {
	echo SKIP fonct_lance  $P1  $P2  $P3  $P4
	continue;
    }
    
    LOG=traces.lance_all_tests.$P1.$P2.$P3.$P4.$(date +%s).log
    
    echo fonct_lance  $P1  $P2  $P3  $P4 
    date_deb=$(date +%s)
    fonct_lance  $P1  $P2  $P3  $P4   2>&1 | tee $LOG
    date_deb=$(date +%s)
    
done



